// ---------------------------
// Wimpy FLAC Controller  v1.0.2
// ---------------------------
// By Mike Gieson 
// www.wimpyplayer.com
// wimpy.flac.js is released under the MIT license.
//
// --------------------
// USING:
// --------------------
// Aurora.js
// --------------------
// https://github.com/audiocogs/aurora.js/
// Written by @jensnockert and @devongovett of Audiocogs.
// Aurora.js is released under the MIT license.
//
// Files included from the Aurora project:
//  - aurora.js
//  - flac.js
//
// --------------------
// NOTES:
//  Seeking with FLAC requires 1 second interval seektables set up 
// 	within the files. Use the "metaflac" tools to add a seektable 
//  entry every second:
// 
// 	Download (For Windows and *nix):
// 	https://xiph.org/flac/download.html
// 	
// 	# Or install metaflac tools for Mac:
// 		$ brew install flac
// 	
// 	# Add seektable:
// 		$ cd /path/to/flac/files/
//  	$ metaflac --add-seekpoint=1s *.flac
// 
// --------------------

this.wimpy=this.wimpy||{},function(){"use strict";jbeeb.mimes.audio.flac="audio/flac";var a=window.AudioContext||window.webkitAudioContext,b=jbeeb.MediaController,c=a?b.prototype:{};c._AROR_player=null,c._AROR_volume=1,c._AROR_live=!1,c._CORE_MC_loadAndPlay=c.loadAndPlay,c.loadAndPlay=function(a,c){var d=b.getMediaInfo(a,c);if("flac"==d.ext||"flac"==c){this.destroy_AROR_player(),this._AROR_live=!0,this.disableOthers(),this.fileInfo=d,this.file=a;var e=AV.Player.fromURL(a);e.on("buffer",this._AROR_watchLoadState.bind(this)),e.on("ready",this._AROR_readyPlay.bind(this)),e.on("progress",this._AROR_updateProgress.bind(this)),e.on("end",this._AROR_end.bind(this)),e.on("error",this._AROR_error.bind(this)),this._AROR_player=e,this.dispatchEvent("playpause",1),this.dispatchEvent("loadStart",this.file),e.preload()}else this._AROR_live=!1,this._CORE_MC_loadAndPlay(a,c)},c._AROR_error=function(a){console.log("_AROR_error",a)},c._CORE_MC_play=c.play,c.play=function(a,b){var c=!1;a&&a!=this.file&&(this.loadAndPlay(jbeeb.Utils.absoluteURL(a),b),c=!0),c||(this._AROR_live?(this._AROR_player.play(),this.dispatchEvent("start",this.file)):this._CORE_MC_play())},c._CORE_MC_pause=c.pause,c.pause=function(a){this._AROR_live?this._AROR_player&&(this._AROR_player.pause(),this.dispatchEvent("pause",this.file)):this._CORE_MC_pause(a)},c._CORE_MC_stop=c.stop,c.stop=function(a){this._AROR_live?(this.reset(a),this.dispatchEvent("stop",this.file)):this._CORE_MC_stop(a)},c._CORE_MC_reset=c.reset,c.reset=function(a){this._AROR_live?(this.pause(),this.rewind(),this.fileInfo=null,this.file=null,this.setVolume(this.amMuted?this._muteVolMem||1:this._volume),a&&this.destroy_AROR_player()):this._CORE_MC_reset(a)},c.destroy_AROR_player=function(){var a=this._AROR_player;a&&(a.stop(),a.off("buffer"),a.off("format"),a.off("progress"),a.off("duration"),a.off("metadata"),this._AROR_player=null)},c._CORE_MC_rewind=c.rewind,c.rewind=function(){this._AROR_live?this.setPlayheadPercent(0):this._CORE_MC_rewind()},c._CORE_MC_setPlayheadPercent=c.setPlayheadPercent,c.setPlayheadPercent=function(a){if(this._AROR_live){if(this._AROR_player){var b=this._AROR_player.duration;b&&b!==1/0&&b!==0/0||(b=0);var c=b*a;0>c?c=0:c>b&&(c=b),this._AROR_player.seek(c)}}else this._CORE_MC_setPlayheadPercent(a)},c._CORE_MC_setVolume=c.setVolume,c.setVolume=function(a){this._AROR_live?(this._AROR_player&&(this._AROR_player.volume=100*a),this._AROR_volume=a):this._CORE_MC_setVolume(a)},c._CORE_MC_mute=c.mute,c.mute=function(a){if(this._AROR_live){var b=0;a?(this._muteVolMem=this._AROR_volume||1,b=0):b=this._muteVolMem||1,this.amMuted=a,this.setVolume(v)}else this._CORE_MC_mute(a)},c._AROR_readyPlay=function(a){this._AROR_player.play(),this.setVolume(this._AROR_volume),this.dispatchEvent("launch",this.file),this.dispatchEvent("start",this.file)},c._AROR_updateProgress=function(a){this._AROR_watchPlayerState()},c._AROR_end=function(){this.reset(),this._AROR_watchPlayerState(!0),this.dispatchEvent("done",this.file)},c._AROR_watchLoadState=function(a){var b=a>=100?1:0,c={loaded:1,percent:a/100||0,total:15,status:0};this.setLoadState(c),this.dispatchEvent("loading",c)},c._AROR_watchPlayerState=function(a){var b=1,c=this._AROR_player.playing?1:0,d=!1,e=this._AROR_player.currentTime||0,f=this._AROR_player.duration||e+1;a&&(c=0,f=1);var g=e/1e3,h=f/1e3,i=g/h,j=h-g,k="00:00",l="00:00",m="00:00";g>0&&(k=this.niceTime(g),l=this.niceTime(h),m=this.niceTime(j));var n={init:b,status:c,percent:i,duration:h,duration_nice:l,remaining:j,remaining_nice:m,current:g,current_nice:k,buffering:d,thinking:0};this.setPlayerState(n),this.dispatchEvent("update",n)}}(),function(){function a(a,b,c,d,e){this.fromSampleRate=a,this.toSampleRate=b,this.channels=0|c,this.outputBufferSize=d,this.noReturn=!!e,this.initialize()}var b;b=this;var c;c={};var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a},f=[].indexOf||function(a){for(var b=0,c=this.length;c>b;b++)if(b in this&&this[b]===a)return b;return-1};c.Base=function(){function a(){}var b;return b=/\b_super\b/,a.extend=function(a){var c,d,g,h,i,j;if(c=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}return e(b,a),b}(this),"function"==typeof a){h=Object.keys(c.prototype),a.call(c,c),a={},i=c.prototype;for(g in i)d=i[g],f.call(h,g)<0&&(a[g]=d)}j=c.__super__;for(g in a)d=a[g],"function"==typeof d&&b.test(d)?!function(a,b){return c.prototype[a]=function(){var c,d;return d=this._super,this._super=j[a],c=b.apply(this,arguments),this._super=d,c}}(g,d):c.prototype[g]=d;return c},a}(),c.Buffer=function(){function a(a){var d;if(a instanceof Uint8Array)this.data=a;else if(a instanceof ArrayBuffer||Array.isArray(a)||"number"==typeof a||c.isNode&&(null!=(d=b.Buffer)?d.isBuffer(a):void 0))this.data=new Uint8Array(a);else if(a.buffer instanceof ArrayBuffer)this.data=new Uint8Array(a.buffer,a.byteOffset,a.length*a.BYTES_PER_ELEMENT);else{if(!(a instanceof c.Buffer))throw new Error("Constructing buffer with unknown type.");this.data=a.data}this.length=this.data.length,this.next=null,this.prev=null}var d,e;return a.allocate=function(a){return new c.Buffer(a)},a.prototype.copy=function(){return new c.Buffer(new Uint8Array(this.data))},a.prototype.slice=function(a,b){return null==b&&(b=this.length),new c.Buffer(0===a&&b>=this.length?this.data:this.data.subarray(a,a+b))},d=b.BlobBuilder||b.MozBlobBuilder||b.WebKitBlobBuilder,e=b.URL||b.webkitURL||b.mozURL,a.makeBlob=function(a,b){var c;null==b&&(b="application/octet-stream");try{return new Blob([a],{type:b})}catch(e){}return null!=d?(c=new d,c.append(a),c.getBlob(b)):null},a.makeBlobURL=function(a,b){return null!=e?e.createObjectURL(this.makeBlob(a,b)):void 0},a.revokeBlobURL=function(a){return null!=e?e.revokeObjectURL(a):void 0},a.prototype.toBlob=function(){return a.makeBlob(this.data.buffer)},a.prototype.toBlobURL=function(){return a.makeBlobURL(this.data.buffer)},a}(),c.BufferList=function(){function a(){this.first=null,this.last=null,this.numBuffers=0,this.availableBytes=0,this.availableBuffers=0}return a.prototype.copy=function(){var a;return a=new c.BufferList,a.first=this.first,a.last=this.last,a.numBuffers=this.numBuffers,a.availableBytes=this.availableBytes,a.availableBuffers=this.availableBuffers,a},a.prototype.append=function(a){var b;return a.prev=this.last,null!=(b=this.last)&&(b.next=a),this.last=a,null==this.first&&(this.first=a),this.availableBytes+=a.length,this.availableBuffers++,this.numBuffers++},a.prototype.advance=function(){return this.first?(this.availableBytes-=this.first.length,this.availableBuffers--,this.first=this.first.next,null!=this.first):!1},a.prototype.rewind=function(){var a;return this.first&&!this.first.prev?!1:(this.first=(null!=(a=this.first)?a.prev:void 0)||this.last,this.first&&(this.availableBytes+=this.first.length,this.availableBuffers++),null!=this.first)},a.prototype.reset=function(){var a;for(a=[];this.rewind(););return a},a}();var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.Stream=function(){function a(a){this.list=a,this.localOffset=0,this.offset=0}var b,d,f,g,h,i,j,k,l,m,n,o,p;return b=new ArrayBuffer(16),p=new Uint8Array(b),l=new Int8Array(b),n=new Uint16Array(b),j=new Int16Array(b),o=new Uint32Array(b),k=new Int32Array(b),f=new Float32Array(b),"undefined"!=typeof Float64Array&&null!==Float64Array&&(g=new Float64Array(b)),m=13330===new Uint16Array(new Uint8Array([18,52]).buffer)[0],c.UnderflowError=function(a){function b(){this.name="AV.UnderflowError"}return e(b,a),b}(Error),a.fromBuffer=function(a){var b;return b=new c.BufferList,b.append(a),new c.Stream(b)},a.prototype.copy=function(){var a;return a=new c.Stream(this.list.copy()),a.localOffset=this.localOffset,a.offset=this.offset,a},a.prototype.available=function(a){return a<=this.list.availableBytes-this.localOffset},a.prototype.remainingBytes=function(){return this.list.availableBytes-this.localOffset},a.prototype.advance=function(a){if(!this.available(a))throw new c.UnderflowError;for(this.localOffset+=a,this.offset+=a;this.list.first&&this.localOffset>=this.list.first.length;)this.localOffset-=this.list.first.length,this.list.advance();return this},a.prototype.rewind=function(a){if(a>this.offset)throw new c.UnderflowError;for(this.list.first||(this.list.rewind(),this.localOffset=this.list.first.length),this.localOffset-=a,this.offset-=a;this.list.first.prev&&this.localOffset<0;)this.list.rewind(),this.localOffset+=this.list.first.length;return this},a.prototype.seek=function(a){return a>this.offset?this.advance(a-this.offset):a<this.offset?this.rewind(this.offset-a):void 0},a.prototype.readUInt8=function(){var a;if(!this.available(1))throw new c.UnderflowError;return a=this.list.first.data[this.localOffset],this.localOffset+=1,this.offset+=1,this.localOffset===this.list.first.length&&(this.localOffset=0,this.list.advance()),a},a.prototype.peekUInt8=function(a){var b;if(null==a&&(a=0),!this.available(a+1))throw new c.UnderflowError;for(a=this.localOffset+a,b=this.list.first;b;){if(b.length>a)return b.data[a];a-=b.length,b=b.next}return 0},a.prototype.read=function(a,b){var c,d,e,f;if(null==b&&(b=!1),b===m)for(c=d=0;a>d;c=d+=1)p[c]=this.readUInt8();else for(c=e=f=a-1;e>=0;c=e+=-1)p[c]=this.readUInt8()},a.prototype.peek=function(a,b,c){var d,e,f;if(null==c&&(c=!1),c===m)for(d=e=0;a>e;d=e+=1)p[d]=this.peekUInt8(b+d);else for(d=f=0;a>f;d=f+=1)p[a-d-1]=this.peekUInt8(b+d)},a.prototype.readInt8=function(){return this.read(1),l[0]},a.prototype.peekInt8=function(a){return null==a&&(a=0),this.peek(1,a),l[0]},a.prototype.readUInt16=function(a){return this.read(2,a),n[0]},a.prototype.peekUInt16=function(a,b){return null==a&&(a=0),this.peek(2,a,b),n[0]},a.prototype.readInt16=function(a){return this.read(2,a),j[0]},a.prototype.peekInt16=function(a,b){return null==a&&(a=0),this.peek(2,a,b),j[0]},a.prototype.readUInt24=function(a){return a?this.readUInt16(!0)+(this.readUInt8()<<16):(this.readUInt16()<<8)+this.readUInt8()},a.prototype.peekUInt24=function(a,b){return null==a&&(a=0),b?this.peekUInt16(a,!0)+(this.peekUInt8(a+2)<<16):(this.peekUInt16(a)<<8)+this.peekUInt8(a+2)},a.prototype.readInt24=function(a){return a?this.readUInt16(!0)+(this.readInt8()<<16):(this.readInt16()<<8)+this.readUInt8()},a.prototype.peekInt24=function(a,b){return null==a&&(a=0),b?this.peekUInt16(a,!0)+(this.peekInt8(a+2)<<16):(this.peekInt16(a)<<8)+this.peekUInt8(a+2)},a.prototype.readUInt32=function(a){return this.read(4,a),o[0]},a.prototype.peekUInt32=function(a,b){return null==a&&(a=0),this.peek(4,a,b),o[0]},a.prototype.readInt32=function(a){return this.read(4,a),k[0]},a.prototype.peekInt32=function(a,b){return null==a&&(a=0),this.peek(4,a,b),k[0]},a.prototype.readFloat32=function(a){return this.read(4,a),f[0]},a.prototype.peekFloat32=function(a,b){return null==a&&(a=0),this.peek(4,a,b),f[0]},a.prototype.readFloat64=function(a){return this.read(8,a),g?g[0]:h()},h=function(){var a,b,c,d,e,f;return d=o[0],c=o[1],c&&2147483648!==c?(f=1-2*(c>>>31),a=c>>>20&2047,b=1048575&c,2047===a?b?0/0:f*(1/0):(a-=1023,e=(1048576|b)*Math.pow(2,a-20),e+=d*Math.pow(2,a-52),f*e)):0},a.prototype.peekFloat64=function(a,b){return null==a&&(a=0),this.peek(8,a,b),g?g[0]:h()},a.prototype.readFloat80=function(a){return this.read(10,a),i()},i=function(){var a,b,c,d,e,f,g;return d=o[0],e=o[1],a=p[9],b=p[8],g=1-2*(a>>>7),c=(127&a)<<8|b,0===c&&0===e&&0===d?0:32767===c?0===e&&0===d?g*(1/0):0/0:(c-=16383,f=e*Math.pow(2,c-31),f+=d*Math.pow(2,c-63),g*f)},a.prototype.peekFloat80=function(a,b){return null==a&&(a=0),this.peek(10,a,b),i()},a.prototype.readBuffer=function(a){var b,d,e,f;for(d=c.Buffer.allocate(a),e=d.data,b=f=0;a>f;b=f+=1)e[b]=this.readUInt8();return d},a.prototype.peekBuffer=function(a,b){var d,e,f,g;for(null==a&&(a=0),e=c.Buffer.allocate(b),f=e.data,d=g=0;b>g;d=g+=1)f[d]=this.peekUInt8(a+d);return e},a.prototype.readSingleBuffer=function(a){var b;return b=this.list.first.slice(this.localOffset,a),this.advance(b.length),b},a.prototype.peekSingleBuffer=function(a,b){var c;return c=this.list.first.slice(this.localOffset+a,b)},a.prototype.readString=function(a,b){return null==b&&(b="ascii"),d.call(this,0,a,b,!0)},a.prototype.peekString=function(a,b,c){return null==a&&(a=0),null==c&&(c="ascii"),d.call(this,a,b,c,!1)},d=function(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q;switch(c=c.toLowerCase(),m=null===b?0:-1,null==b&&(b=1/0),k=a+b,o="",c){case"ascii":case"latin1":for(;k>a&&(j=this.peekUInt8(a++))!==m;)o+=String.fromCharCode(j);break;case"utf8":case"utf-8":for(;k>a&&(e=this.peekUInt8(a++))!==m;)0===(128&e)?o+=String.fromCharCode(e):192===(224&e)?(f=63&this.peekUInt8(a++),o+=String.fromCharCode((31&e)<<6|f)):224===(240&e)?(f=63&this.peekUInt8(a++),g=63&this.peekUInt8(a++),o+=String.fromCharCode((15&e)<<12|f<<6|g)):240===(248&e)&&(f=63&this.peekUInt8(a++),g=63&this.peekUInt8(a++),h=63&this.peekUInt8(a++),n=((15&e)<<18|f<<12|g<<6|h)-65536,o+=String.fromCharCode(55296+(n>>10),56320+(1023&n)));break;case"utf16-be":case"utf16be":case"utf16le":case"utf16-le":case"utf16bom":case"utf16-bom":switch(c){case"utf16be":case"utf16-be":l=!1;break;case"utf16le":case"utf16-le":l=!0;break;case"utf16bom":case"utf16-bom":if(2>b||(i=this.peekUInt16(a))===m)return d&&this.advance(a+=2),o;l=65534===i,a+=2}for(;k>a&&(p=this.peekUInt16(a,l))!==m;)if(a+=2,55296>p||p>57343)o+=String.fromCharCode(p);else{if(p>56319)throw new Error("Invalid utf16 sequence.");if(q=this.peekUInt16(a,l),56320>q||q>57343)throw new Error("Invalid utf16 sequence.");o+=String.fromCharCode(p,q),a+=2}p===m&&(a+=2);break;default:throw new Error("Unknown encoding: "+c)}return d&&this.advance(a),o},a}(),c.Bitstream=function(){function a(a){this.stream=a,this.bitPosition=0}return a.prototype.copy=function(){var a;return a=new c.Bitstream(this.stream.copy()),a.bitPosition=this.bitPosition,a},a.prototype.offset=function(){return 8*this.stream.offset+this.bitPosition},a.prototype.available=function(a){return this.stream.available((a+8-this.bitPosition)/8)},a.prototype.advance=function(a){var b;return b=this.bitPosition+a,this.stream.advance(b>>3),this.bitPosition=7&b},a.prototype.rewind=function(a){var b;return b=this.bitPosition-a,this.stream.rewind(Math.abs(b>>3)),this.bitPosition=7&b},a.prototype.seek=function(a){var b;return b=this.offset(),a>b?this.advance(a-b):b>a?this.rewind(b-a):void 0},a.prototype.align=function(){return 0!==this.bitPosition?(this.bitPosition=0,this.stream.advance(1)):void 0},a.prototype.read=function(a,b){var c,d,e,f,g,h,i;if(0===a)return 0;if(i=a+this.bitPosition,8>=i)c=(this.stream.peekUInt8()<<this.bitPosition&255)>>>8-a;else if(16>=i)c=(this.stream.peekUInt16()<<this.bitPosition&65535)>>>16-a;else if(24>=i)c=(this.stream.peekUInt24()<<this.bitPosition&16777215)>>>24-a;else if(32>=i)c=this.stream.peekUInt32()<<this.bitPosition>>>32-a;else{if(!(40>=i))throw new Error("Too many bits!");d=4294967296*this.stream.peekUInt8(0),e=this.stream.peekUInt8(1)<<24>>>0,f=this.stream.peekUInt8(2)<<16,g=this.stream.peekUInt8(3)<<8,h=this.stream.peekUInt8(4),c=d+e+f+g+h,c%=Math.pow(2,40-this.bitPosition),c=Math.floor(c/Math.pow(2,40-this.bitPosition-a))}return b&&(32>i?c>>>a-1&&(c=-1*((1<<a>>>0)-c)):c/Math.pow(2,a-1)|0&&(c=-1*(Math.pow(2,a)-c))),this.advance(a),c},a.prototype.peek=function(a,b){var c,d,e,f,g,h,i;if(0===a)return 0;if(i=a+this.bitPosition,8>=i)c=(this.stream.peekUInt8()<<this.bitPosition&255)>>>8-a;else if(16>=i)c=(this.stream.peekUInt16()<<this.bitPosition&65535)>>>16-a;else if(24>=i)c=(this.stream.peekUInt24()<<this.bitPosition&16777215)>>>24-a;else if(32>=i)c=this.stream.peekUInt32()<<this.bitPosition>>>32-a;else{if(!(40>=i))throw new Error("Too many bits!");d=4294967296*this.stream.peekUInt8(0),e=this.stream.peekUInt8(1)<<24>>>0,f=this.stream.peekUInt8(2)<<16,g=this.stream.peekUInt8(3)<<8,h=this.stream.peekUInt8(4),c=d+e+f+g+h,c%=Math.pow(2,40-this.bitPosition),c=Math.floor(c/Math.pow(2,40-this.bitPosition-a))}return b&&(32>i?c>>>a-1&&(c=-1*((1<<a>>>0)-c)):c/Math.pow(2,a-1)|0&&(c=-1*(Math.pow(2,a)-c))),c},a.prototype.readLSB=function(a,b){var c,d;if(0===a)return 0;if(a>40)throw new Error("Too many bits!");return d=a+this.bitPosition,c=this.stream.peekUInt8(0)>>>this.bitPosition,d>8&&(c|=this.stream.peekUInt8(1)<<8-this.bitPosition),d>16&&(c|=this.stream.peekUInt8(2)<<16-this.bitPosition),d>24&&(c+=this.stream.peekUInt8(3)<<24-this.bitPosition>>>0),d>32&&(c+=this.stream.peekUInt8(4)*Math.pow(2,32-this.bitPosition)),d>=32?c%=Math.pow(2,a):c&=(1<<a)-1,b&&(32>d?c>>>a-1&&(c=-1*((1<<a>>>0)-c)):c/Math.pow(2,a-1)|0&&(c=-1*(Math.pow(2,a)-c))),this.advance(a),c},a.prototype.peekLSB=function(a,b){var c,d;if(0===a)return 0;if(a>40)throw new Error("Too many bits!");return d=a+this.bitPosition,c=this.stream.peekUInt8(0)>>>this.bitPosition,d>8&&(c|=this.stream.peekUInt8(1)<<8-this.bitPosition),d>16&&(c|=this.stream.peekUInt8(2)<<16-this.bitPosition),d>24&&(c+=this.stream.peekUInt8(3)<<24-this.bitPosition>>>0),d>32&&(c+=this.stream.peekUInt8(4)*Math.pow(2,32-this.bitPosition)),d>=32?c%=Math.pow(2,a):c&=(1<<a)-1,b&&(32>d?c>>>a-1&&(c=-1*((1<<a>>>0)-c)):c/Math.pow(2,a-1)|0&&(c=-1*(Math.pow(2,a)-c))),c},a}();var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a},g=[].slice;c.EventEmitter=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}return e(b,a),b.prototype.on=function(a,b){var c;return null==this.events&&(this.events={}),null==(c=this.events)[a]&&(c[a]=[]),this.events[a].push(b)},b.prototype.off=function(a,b){var c,d;if(null!=(d=this.events)?d[a]:void 0)return c=this.events[a].indexOf(b),~c?this.events[a].splice(c,1):void 0},b.prototype.once=function(a,b){var c;return this.on(a,c=function(){return this.off(a,c),b.apply(this,arguments)})},b.prototype.emit=function(){var a,b,c,d,e,f,h;if(b=arguments[0],a=2<=arguments.length?g.call(arguments,1):[],null!=(f=this.events)?f[b]:void 0)for(h=this.events[b].slice(),d=0,e=h.length;e>d;d++)c=h[d],c.apply(this,a)},b}(c.Base);var h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.BufferSource=function(a){function d(a){this.loop=h(this.loop,this),a instanceof c.BufferList?this.list=a:(this.list=new c.BufferList,this.list.append(new c.Buffer(a))),this.paused=!0}var f,g;return e(d,a),g=b.setImmediate||function(a){return b.setTimeout(a,0)},f=b.clearImmediate||function(a){return b.clearTimeout(a)},d.prototype.start=function(){return this.paused=!1,this._timer=g(this.loop)},d.prototype.loop=function(){return this.emit("progress",(this.list.numBuffers-this.list.availableBuffers+1)/this.list.numBuffers*100|0),this.emit("data",this.list.first),this.list.advance()?g(this.loop):this.emit("end")},d.prototype.pause=function(){return f(this._timer),this.paused=!0},d.prototype.reset=function(){return this.pause(),this.list.rewind()},d}(c.EventEmitter);var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.Demuxer=function(a){function b(a,b){var d,e;d=new c.BufferList,d.append(b),this.stream=new c.Stream(d),e=!1,a.on("data",function(a){return function(b){return e=!0,d.append(b),a.readChunk(b)}}(this)),a.on("error",function(a){return function(b){return a.emit("error",b)}}(this)),a.on("end",function(a){return function(){return e||a.readChunk(b),a.emit("end")}}(this)),this.seekPoints=[],this.init()}var d;return e(b,a),b.probe=function(a){return!1},b.prototype.init=function(){},b.prototype.readChunk=function(a){},b.prototype.addSeekPoint=function(a,b){var c;return c=this.searchTimestamp(b),this.seekPoints.splice(c,0,{offset:a,timestamp:b})},b.prototype.searchTimestamp=function(a,b){var c,d,e,f;if(d=0,c=this.seekPoints.length,c>0&&this.seekPoints[c-1].timestamp<a)return c;for(;c>d;)e=d+c>>1,f=this.seekPoints[e].timestamp,a>f?d=e+1:f>=a&&(c=e);return c>this.seekPoints.length&&(c=this.seekPoints.length),c},b.prototype.seek=function(a){var b,c;return this.format&&this.format.framesPerPacket>0&&this.format.bytesPerPacket>0?c={timestamp:a,offset:this.format.bytesPerPacket*a/this.format.framesPerPacket}:(b=this.searchTimestamp(a),this.seekPoints[b])},d=[],b.register=function(a){return d.push(a)},b.find=function(a){var b,e,f,g;for(e=c.Stream.fromBuffer(a),f=0,g=d.length;g>f;f++)if(b=d[f],b.probe(e))return b;return null},b}(c.EventEmitter);var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.Decoder=function(a){function b(a,b){var d;this.demuxer=a,this.format=b,d=new c.BufferList,this.stream=new c.Stream(d),this.bitstream=new c.Bitstream(this.stream),this.receivedFinalBuffer=!1,this.waiting=!1,this.demuxer.on("cookie",function(a){return function(b){var c;try{return a.setCookie(b)}catch(d){return c=d,a.emit("error",c)}}}(this)),this.demuxer.on("data",function(a){return function(b){return d.append(b),a.waiting?a.decode():void 0}}(this)),this.demuxer.on("end",function(a){return function(){return a.receivedFinalBuffer=!0,a.waiting?a.decode():void 0}}(this)),this.init()}var d;return e(b,a),b.prototype.init=function(){},b.prototype.setCookie=function(a){},b.prototype.readChunk=function(){},b.prototype.decode=function(){var a,b,d;this.waiting=!1,b=this.bitstream.offset();try{d=this.readChunk()}catch(e){if(a=e,!(a instanceof c.UnderflowError))return this.emit("error",a),!1}return d?(this.emit("data",d),!0):(this.receivedFinalBuffer?this.emit("end"):(this.bitstream.seek(b),this.waiting=!0),!1)},b.prototype.seek=function(a){var b;return b=this.demuxer.seek(a),this.stream.seek(b.offset),b.timestamp},d={},b.register=function(a,b){return d[a]=b},b.find=function(a){return d[a]||null},b}(c.EventEmitter);var h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.Queue=function(a){function b(a){this.asset=a,this.write=h(this.write,this),this.readyMark=64,this.finished=!1,this.buffering=!0,this.ended=!1,this.buffers=[],this.asset.on("data",this.write),this.asset.on("end",function(a){return function(){return a.ended=!0}}(this)),this.asset.decodePacket()}return e(b,a),b.prototype.write=function(a){return a&&this.buffers.push(a),this.buffering?this.buffers.length>=this.readyMark||this.ended?(this.buffering=!1,this.emit("ready")):this.asset.decodePacket():void 0},b.prototype.read=function(){return 0===this.buffers.length?null:(this.asset.decodePacket(),this.buffers.shift())},b.prototype.reset=function(){return this.buffers.length=0,this.buffering=!0,this.asset.decodePacket()},b}(c.EventEmitter);var h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.AudioDevice=function(a){function b(a,b){this.sampleRate=a,this.channels=b,this.updateTime=h(this.updateTime,this),this.playing=!1,this.currentTime=0,this._lastTime=0}var d;return e(b,a),b.prototype.start=function(){if(!this.playing){if(this.playing=!0,null==this.device&&(this.device=c.AudioDevice.create(this.sampleRate,this.channels)),!this.device)throw new Error("No supported audio device found.");return this._lastTime=this.device.getDeviceTime(),this._timer=setInterval(this.updateTime,200),this.device.on("refill",this.refill=function(a){return function(b){return a.emit("refill",b)}}(this))}},b.prototype.stop=function(){return this.playing?(this.playing=!1,this.device.off("refill",this.refill),clearInterval(this._timer)):void 0},b.prototype.destroy=function(){return this.stop(),this.device.destroy()},b.prototype.seek=function(a){return this.currentTime=a,this.playing&&(this._lastTime=this.device.getDeviceTime()),this.emit("timeUpdate",this.currentTime)},b.prototype.updateTime=function(){var a;return a=this.device.getDeviceTime(),this.currentTime+=(a-this._lastTime)/this.device.sampleRate*1e3|0,this._lastTime=a,this.emit("timeUpdate",this.currentTime)},d=[],b.register=function(a){return d.push(a)},b.create=function(a,b){var c,e,f;for(e=0,f=d.length;f>e;e++)if(c=d[e],c.supported)return new c(a,b);return null},b}(c.EventEmitter);var h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.Asset=function(a){function b(a){this.source=a,this._decode=h(this._decode,this),this.findDecoder=h(this.findDecoder,this),this.probe=h(this.probe,this),this.buffered=0,this.duration=null,this.format=null,this.metadata=null,this.active=!1,this.demuxer=null,this.decoder=null,this.source.once("data",this.probe),this.source.on("error",function(a){return function(b){return a.emit("error",b),a.stop()}}(this)),this.source.on("progress",function(a){return function(b){return a.buffered=b,a.emit("buffer",a.buffered)}}(this))}return e(b,a),b.fromURL=function(a){return new c.Asset(new c.HTTPSource(a))},b.fromFile=function(a){return new c.Asset(new c.FileSource(a))},b.fromBuffer=function(a){return new c.Asset(new c.BufferSource(a))},b.prototype.start=function(a){return this.active?void 0:(null!=a&&(this.shouldDecode=a),null==this.shouldDecode&&(this.shouldDecode=!0),this.active=!0,this.source.start(),this.decoder&&this.shouldDecode?this._decode():void 0)},b.prototype.stop=function(){return this.active?(this.active=!1,this.source.pause()):void 0},b.prototype.get=function(a,b){return"format"===a||"duration"===a||"metadata"===a?null!=this[a]?b(this[a]):(this.once(a,function(a){return function(c){return a.stop(),b(c)}}(this)),this.start()):void 0},b.prototype.decodePacket=function(){return this.decoder.decode()},b.prototype.decodeToBuffer=function(a){var b,c,d;return d=0,b=[],this.on("data",c=function(a){return d+=a.length,b.push(a)}),this.once("end",function(){var e,f,g,h,i;for(e=new Float32Array(d),g=0,h=0,i=b.length;i>h;h++)f=b[h],e.set(f,g),g+=f.length;return this.off("data",c),a(e)}),this.start()},b.prototype.probe=function(a){var b;if(this.active)return(b=c.Demuxer.find(a))?(this.demuxer=new b(this.source,a),this.demuxer.on("format",this.findDecoder),this.demuxer.on("duration",function(a){return function(b){return a.duration=b,a.emit("duration",a.duration)}}(this)),this.demuxer.on("metadata",function(a){return function(b){return a.metadata=b,a.emit("metadata",a.metadata)}}(this)),this.demuxer.on("error",function(a){return function(b){return a.emit("error",b),a.stop()}}(this))):this.emit("error","A demuxer for this container was not found.")},b.prototype.findDecoder=function(a){var b,d;return this.format=a,this.active?(this.emit("format",this.format),(b=c.Decoder.find(this.format.formatID))?(this.decoder=new b(this.demuxer,this.format),this.format.floatingPoint?this.decoder.on("data",function(a){return function(b){return a.emit("data",b)}}(this)):(d=Math.pow(2,this.format.bitsPerChannel-1),this.decoder.on("data",function(a){return function(b){var c,e,f,g,h;for(c=new Float32Array(b.length),e=g=0,h=b.length;h>g;e=++g)f=b[e],c[e]=f/d;return a.emit("data",c)}}(this))),this.decoder.on("error",function(a){return function(b){return a.emit("error",b),a.stop()}}(this)),this.decoder.on("end",function(a){return function(){return a.emit("end")}}(this)),this.emit("decodeStart"),this.shouldDecode?this._decode():void 0):this.emit("error","A decoder for "+this.format.formatID+" was not found.")):void 0},b.prototype._decode=function(){for(;this.decoder.decode()&&this.active;);return this.active?this.decoder.once("data",this._decode):void 0},b}(c.EventEmitter);var h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.Player=function(a){function b(a){this.asset=a,this.startPlaying=h(this.startPlaying,this),this.playing=!1,this.buffered=0,this.currentTime=0,this.duration=0,this.volume=100,this.pan=0,this.metadata={},this.filters=[new c.VolumeFilter(this,"volume"),new c.BalanceFilter(this,"pan")],this.asset.on("buffer",function(a){return function(b){return a.buffered=b,a.emit("buffer",a.buffered)}}(this)),this.asset.on("decodeStart",function(a){return function(){return a.queue=new c.Queue(a.asset),a.queue.once("ready",a.startPlaying)}}(this)),this.asset.on("format",function(a){return function(b){return a.format=b,a.emit("format",a.format)}}(this)),this.asset.on("metadata",function(a){return function(b){return a.metadata=b,a.emit("metadata",a.metadata)}}(this)),this.asset.on("duration",function(a){return function(b){return a.duration=b,a.emit("duration",a.duration)}}(this)),this.asset.on("error",function(a){return function(b){return a.emit("error",b)}}(this))}return e(b,a),b.fromURL=function(a){return new c.Player(c.Asset.fromURL(a))},b.fromFile=function(a){return new c.Player(c.Asset.fromFile(a))},b.fromBuffer=function(a){return new c.Player(c.Asset.fromBuffer(a))},b.prototype.preload=function(){return this.asset?(this.startedPreloading=!0,this.asset.start(!1)):void 0},b.prototype.play=function(){var a;if(!this.playing)return this.startedPreloading||this.preload(),this.playing=!0,null!=(a=this.device)?a.start():void 0},b.prototype.pause=function(){var a;if(this.playing)return this.playing=!1,null!=(a=this.device)?a.stop():void 0},b.prototype.togglePlayback=function(){return this.playing?this.pause():this.play()},b.prototype.stop=function(){var a;return this.pause(),this.asset.stop(),null!=(a=this.device)?a.destroy():void 0},b.prototype.seek=function(a){var b;return null!=(b=this.device)&&b.stop(),this.queue.once("ready",function(a){return function(){var b,c;return null!=(b=a.device)&&b.seek(a.currentTime),a.playing&&null!=(c=a.device)?c.start():void 0}}(this)),a=a/1e3*this.format.sampleRate,a=this.asset.decoder.seek(a),this.currentTime=a/this.format.sampleRate*1e3|0,this.queue.reset(),this.currentTime},b.prototype.startPlaying=function(){var a,b;return a=this.queue.read(),b=0,this.device=new c.AudioDevice(this.format.sampleRate,this.format.channelsPerFrame),this.device.on("timeUpdate",function(a){return function(b){return a.currentTime=b,a.emit("progress",a.currentTime)}}(this)),this.refill=function(c){return function(d){var e,f,g,h,i,j,k,l;if(c.playing){for(a||(a=c.queue.read(),b=0),e=0;a&&e<d.length;){for(h=Math.min(a.length-b,d.length-e),g=i=0;h>i;g=i+=1)d[e++]=a[b++];b===a.length&&(a=c.queue.read(),b=0)}for(l=c.filters,j=0,k=l.length;k>j;j++)f=l[j],f.process(d);a||(c.queue.ended?(c.currentTime=c.duration,c.emit("progress",c.currentTime),c.emit("end"),c.stop()):c.device.stop())}}}(this),this.device.on("refill",this.refill),this.playing&&this.device.start(),this.emit("ready")},b}(c.EventEmitter),c.Filter=function(){function a(a,b){a&&b&&Object.defineProperty(this,"value",{get:function(){return a[b]}})}return a.prototype.process=function(a){},a}();var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.VolumeFilter=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}return e(b,a),b.prototype.process=function(a){var b,c,d,e;if(!(this.value>=100))for(c=Math.max(0,Math.min(100,this.value))/100,
b=d=0,e=a.length;e>d;b=d+=1)a[b]*=c},b}(c.Filter);var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.BalanceFilter=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}return e(b,a),b.prototype.process=function(a){var b,c,d,e;if(0!==this.value)for(c=Math.max(-50,Math.min(50,this.value)),b=d=0,e=a.length;e>d;b=d+=2)a[b]*=Math.min(1,(50-c)/50),a[b+1]*=Math.min(1,(50+c)/50)},b}(c.Filter);var i,d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};i=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}return e(b,a),c.Demuxer.register(b),b.probe=function(a){return"caff"===a.peekString(0,4)},b.prototype.readChunk=function(){var a,b,c,d,e,f,g,h,i,k,l,m,n,o;if(!this.format&&this.stream.available(64)){if("caff"!==this.stream.readString(4))return this.emit("error","Invalid CAF, does not begin with 'caff'");if(this.stream.advance(4),"desc"!==this.stream.readString(4))return this.emit("error","Invalid CAF, 'caff' is not followed by 'desc'");if(0!==this.stream.readUInt32()||32!==this.stream.readUInt32())return this.emit("error","Invalid 'desc' size, should be 32");this.format={},this.format.sampleRate=this.stream.readFloat64(),this.format.formatID=this.stream.readString(4),e=this.stream.readUInt32(),"lpcm"===this.format.formatID&&(this.format.floatingPoint=Boolean(1&e),this.format.littleEndian=Boolean(2&e)),this.format.bytesPerPacket=this.stream.readUInt32(),this.format.framesPerPacket=this.stream.readUInt32(),this.format.channelsPerFrame=this.stream.readUInt32(),this.format.bitsPerChannel=this.stream.readUInt32(),this.emit("format",this.format)}for(;this.stream.available(1);){if(!this.headerCache&&(this.headerCache={type:this.stream.readString(4),oversize:0!==this.stream.readUInt32(),size:this.stream.readUInt32()},this.headerCache.oversize))return this.emit("error","Holy Shit, an oversized file, not supported in JS");switch(this.headerCache.type){case"kuki":this.stream.available(this.headerCache.size)&&("aac "===this.format.formatID?(i=this.stream.offset+this.headerCache.size,(c=j.readEsds(this.stream))&&this.emit("cookie",c),this.stream.seek(i)):(a=this.stream.readBuffer(this.headerCache.size),this.emit("cookie",a)),this.headerCache=null);break;case"pakt":if(this.stream.available(this.headerCache.size)){if(0!==this.stream.readUInt32())return this.emit("error","Sizes greater than 32 bits are not supported.");if(this.numPackets=this.stream.readUInt32(),0!==this.stream.readUInt32())return this.emit("error","Sizes greater than 32 bits are not supported.");for(this.numFrames=this.stream.readUInt32(),this.primingFrames=this.stream.readUInt32(),this.remainderFrames=this.stream.readUInt32(),this.emit("duration",this.numFrames/this.format.sampleRate*1e3|0),this.sentDuration=!0,b=0,k=0,f=m=0,o=this.numPackets;o>m;f=m+=1)this.addSeekPoint(b,k),b+=this.format.bytesPerPacket||j.readDescrLen(this.stream),k+=this.format.framesPerPacket||j.readDescrLen(this.stream);this.headerCache=null}break;case"info":for(d=this.stream.readUInt32(),h={},f=n=0;d>=0?d>n:n>d;f=d>=0?++n:--n)g=this.stream.readString(null),l=this.stream.readString(null),h[g]=l;this.emit("metadata",h),this.headerCache=null;break;case"data":this.sentFirstDataChunk||(this.stream.advance(4),this.headerCache.size-=4,0===this.format.bytesPerPacket||this.sentDuration||(this.numFrames=this.headerCache.size/this.format.bytesPerPacket,this.emit("duration",this.numFrames/this.format.sampleRate*1e3|0)),this.sentFirstDataChunk=!0),a=this.stream.readSingleBuffer(this.headerCache.size),this.headerCache.size-=a.length,this.emit("data",a),this.headerCache.size<=0&&(this.headerCache=null);break;default:this.stream.available(this.headerCache.size)&&(this.stream.advance(this.headerCache.size),this.headerCache=null)}}},b}(c.Demuxer);var j,d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a},f=[].indexOf||function(a){for(var b=0,c=this.length;c>b;b++)if(b in this&&this[b]===a)return b;return-1};j=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}var d,g,h,i,j,k,l,m,n,o,p;return e(b,a),c.Demuxer.register(b),g=["M4A ","M4P ","M4B ","M4V ","isom","mp42","qt  "],b.probe=function(a){var b;return"ftyp"===a.peekString(4,4)&&(b=a.peekString(8,4),f.call(g,b)>=0)},b.prototype.init=function(){return this.atoms=[],this.offsets=[],this.track=null,this.tracks=[]},j={},l={},i=function(a,b){var c,d,e,f,g;for(c=[],g=a.split(".").slice(0,-1),e=0,f=g.length;f>e;e++)d=g[e],c.push(d),l[c.join(".")]=!0;return null==j[a]&&(j[a]={}),j[a].fn=b},h=function(a,b){return null==j[a]&&(j[a]={}),j[a].after=b},b.prototype.readChunk=function(){var a,b,c;for(this["break"]=!1;this.stream.available(1)&&!this["break"];){if(!this.readHeaders){if(!this.stream.available(8))return;if(this.len=this.stream.readUInt32()-8,this.type=this.stream.readString(4),0===this.len)continue;this.atoms.push(this.type),this.offsets.push(this.stream.offset+this.len),this.readHeaders=!0}if(b=this.atoms.join("."),a=j[b],null!=a?a.fn:void 0){if(!this.stream.available(this.len)&&"mdat"!==b)return;a.fn.call(this),b in l&&(this.readHeaders=!1)}else if(b in l)this.readHeaders=!1;else{if(!this.stream.available(this.len))return;this.stream.advance(this.len)}for(;this.stream.offset>=this.offsets[this.offsets.length-1];)a=j[this.atoms.join(".")],(null!=a?a.after:void 0)&&a.after.call(this),c=this.atoms.pop(),this.offsets.pop(),this.readHeaders=!1}},i("ftyp",function(){var a;return a=this.stream.readString(4),f.call(g,a)<0?this.emit("error","Not a valid M4A file."):this.stream.advance(this.len-4)}),i("moov.trak",function(){return this.track={},this.tracks.push(this.track)}),i("moov.trak.tkhd",function(){return this.stream.advance(4),this.stream.advance(8),this.track.id=this.stream.readUInt32(),this.stream.advance(this.len-16)}),i("moov.trak.mdia.hdlr",function(){return this.stream.advance(4),this.stream.advance(4),this.track.type=this.stream.readString(4),this.stream.advance(12),this.stream.advance(this.len-24)}),i("moov.trak.mdia.mdhd",function(){return this.stream.advance(4),this.stream.advance(8),this.track.timeScale=this.stream.readUInt32(),this.track.duration=this.stream.readUInt32(),this.stream.advance(4)}),d={ulaw:8,alaw:8,in24:24,in32:32,fl32:32,fl64:64},i("moov.trak.mdia.minf.stbl.stsd",function(){var a,b,c,e,f;return this.stream.advance(4),b=this.stream.readUInt32(),"soun"!==this.track.type?this.stream.advance(this.len-8):1!==b?this.emit("error","Only expecting one entry in sample description atom!"):(this.stream.advance(4),a=this.track.format={},a.formatID=this.stream.readString(4),this.stream.advance(6),this.stream.advance(2),c=this.stream.readUInt16(),this.stream.advance(6),a.channelsPerFrame=this.stream.readUInt16(),a.bitsPerChannel=this.stream.readUInt16(),this.stream.advance(4),a.sampleRate=this.stream.readUInt16(),this.stream.advance(2),1===c?(a.framesPerPacket=this.stream.readUInt32(),this.stream.advance(4),a.bytesPerFrame=this.stream.readUInt32(),this.stream.advance(4)):0!==c&&this.emit("error","Unknown version in stsd atom"),null!=d[a.formatID]&&(a.bitsPerChannel=d[a.formatID]),a.floatingPoint="fl32"===(e=a.formatID)||"fl64"===e,a.littleEndian="sowt"===a.formatID&&a.bitsPerChannel>8,"twos"===(f=a.formatID)||"sowt"===f||"in24"===f||"in32"===f||"fl32"===f||"fl64"===f||"raw "===f||"NONE"===f?a.formatID="lpcm":void 0)}),i("moov.trak.mdia.minf.stbl.stsd.alac",function(){return this.stream.advance(4),this.track.cookie=this.stream.readBuffer(this.len-4)}),i("moov.trak.mdia.minf.stbl.stsd.esds",function(){var a;return a=this.stream.offset+this.len,this.track.cookie=b.readEsds(this.stream),this.stream.seek(a)}),i("moov.trak.mdia.minf.stbl.stsd.wave.enda",function(){return this.track.format.littleEndian=!!this.stream.readUInt16()}),b.readDescrLen=function(a){var b,c,d;for(d=0,c=4;c--&&(b=a.readUInt8(),d=d<<7|127&b,128&b););return d},b.readEsds=function(a){var c,d,e,f;return a.advance(4),f=a.readUInt8(),e=b.readDescrLen(a),3===f?(a.advance(2),d=a.readUInt8(),128&d&&a.advance(2),64&d&&a.advance(a.readUInt8()),32&d&&a.advance(2)):a.advance(2),f=a.readUInt8(),e=b.readDescrLen(a),4===f&&(c=a.readUInt8(),a.advance(1),a.advance(3),a.advance(4),a.advance(4),f=a.readUInt8(),e=b.readDescrLen(a),5===f)?a.readBuffer(e):null},i("moov.trak.mdia.minf.stbl.stts",function(){var a,b,c;for(this.stream.advance(4),a=this.stream.readUInt32(),this.track.stts=[],b=c=0;a>c;b=c+=1)this.track.stts[b]={count:this.stream.readUInt32(),duration:this.stream.readUInt32()};return this.setupSeekPoints()}),i("moov.trak.mdia.minf.stbl.stsc",function(){var a,b,c;for(this.stream.advance(4),a=this.stream.readUInt32(),this.track.stsc=[],b=c=0;a>c;b=c+=1)this.track.stsc[b]={first:this.stream.readUInt32(),count:this.stream.readUInt32(),id:this.stream.readUInt32()};return this.setupSeekPoints()}),i("moov.trak.mdia.minf.stbl.stsz",function(){var a,b,c;if(this.stream.advance(4),this.track.sampleSize=this.stream.readUInt32(),a=this.stream.readUInt32(),0===this.track.sampleSize&&a>0)for(this.track.sampleSizes=[],b=c=0;a>c;b=c+=1)this.track.sampleSizes[b]=this.stream.readUInt32();return this.setupSeekPoints()}),i("moov.trak.mdia.minf.stbl.stco",function(){var a,b,c;for(this.stream.advance(4),a=this.stream.readUInt32(),this.track.chunkOffsets=[],b=c=0;a>c;b=c+=1)this.track.chunkOffsets[b]=this.stream.readUInt32();return this.setupSeekPoints()}),i("moov.trak.tref.chap",function(){var a,b,c;for(a=this.len>>2,this.track.chapterTracks=[],b=c=0;a>c;b=c+=1)this.track.chapterTracks[b]=this.stream.readUInt32()}),b.prototype.setupSeekPoints=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;if(null!=this.track.chunkOffsets&&null!=this.track.stsc&&null!=this.track.sampleSize&&null!=this.track.stts){for(g=0,h=0,h=0,i=0,e=0,c=0,j=0,this.track.seekPoints=[],n=this.track.chunkOffsets,p=[],a=k=0,m=n.length;m>k;a=++k){for(d=n[a],b=l=0,o=this.track.stsc[g].count;o>l;b=l+=1)this.track.seekPoints.push({offset:c,position:d,timestamp:j}),f=this.track.sampleSize||this.track.sampleSizes[e++],c+=f,d+=f,j+=this.track.stts[h].duration,h+1<this.track.stts.length&&++i===this.track.stts[h].count&&(i=0,h++);p.push(g+1<this.track.stsc.length&&a+1===this.track.stsc[g+1].first?g++:void 0)}return p}},h("moov",function(){var a,b,c,d;for(null!=this.mdatOffset&&this.stream.seek(this.mdatOffset-8),d=this.tracks,b=0,c=d.length;c>b;b++)if(a=d[b],"soun"===a.type){this.track=a;break}return"soun"!==this.track.type?(this.track=null,this.emit("error","No audio tracks in m4a file.")):(this.emit("format",this.track.format),this.emit("duration",this.track.duration/this.track.timeScale*1e3|0),this.track.cookie&&this.emit("cookie",this.track.cookie),this.seekPoints=this.track.seekPoints)}),i("mdat",function(){var a,b,c,d,e,f,g,h;if(!this.startedData){if(null==this.mdatOffset&&(this.mdatOffset=this.stream.offset),0===this.tracks.length)return a=Math.min(this.stream.remainingBytes(),this.len),this.stream.advance(a),void(this.len-=a);this.chunkIndex=0,this.stscIndex=0,this.sampleIndex=0,this.tailOffset=0,this.tailSamples=0,this.startedData=!0}if(!this.readChapters){if(this.readChapters=this.parseChapters(),this["break"]=!this.readChapters)return;this.stream.seek(this.mdatOffset)}if(e=this.track.chunkOffsets[this.chunkIndex]+this.tailOffset,c=0,!this.stream.available(e-this.stream.offset))return void(this["break"]=!0);for(this.stream.seek(e);this.chunkIndex<this.track.chunkOffsets.length;){for(d=this.track.stsc[this.stscIndex].count-this.tailSamples,b=0,f=h=0;d>h&&(g=this.track.sampleSize||this.track.sampleSizes[this.sampleIndex],this.stream.available(c+g));f=h+=1)c+=g,b+=g,this.sampleIndex++;if(d>f){this.tailOffset+=b,this.tailSamples+=f;break}if(this.chunkIndex++,this.tailOffset=0,this.tailSamples=0,this.stscIndex+1<this.track.stsc.length&&this.chunkIndex+1===this.track.stsc[this.stscIndex+1].first&&this.stscIndex++,e+c!==this.track.chunkOffsets[this.chunkIndex])break}return c>0?(this.emit("data",this.stream.readBuffer(c)),this["break"]=this.chunkIndex===this.track.chunkOffsets.length):this["break"]=!0}),b.prototype.parseChapters=function(){var a,b,c,d,e,f,g,h,i,j,k,l,m;if(!((null!=(j=this.track.chapterTracks)?j.length:void 0)>0))return!0;for(b=this.track.chapterTracks[0],k=this.tracks,h=0,i=k.length;i>h&&(g=k[h],g.id!==b);h++);for(g.id!==b&&this.emit("error","Chapter track does not exist."),null==this.chapters&&(this.chapters=[]);this.chapters.length<g.seekPoints.length;){if(e=g.seekPoints[this.chapters.length],!this.stream.available(e.position-this.stream.offset+32))return!1;if(this.stream.seek(e.position),c=this.stream.readUInt16(),f=null,!this.stream.available(c))return!1;c>2&&(a=this.stream.peekUInt16(),(65279===a||65534===a)&&(f=this.stream.readString(c,"utf16-bom"))),null==f&&(f=this.stream.readString(c,"utf8")),d=null!=(l=null!=(m=g.seekPoints[this.chapters.length+1])?m.timestamp:void 0)?l:g.duration,this.chapters.push({title:f,timestamp:e.timestamp/g.timeScale*1e3|0,duration:(d-e.timestamp)/g.timeScale*1e3|0})}return this.emit("chapters",this.chapters),!0},i("moov.udta.meta",function(){return this.metadata={},this.stream.advance(4)}),h("moov.udta.meta",function(){return this.emit("metadata",this.metadata)}),o=function(a,b,c){return i("moov.udta.meta.ilst."+a+".data",function(){return this.stream.advance(8),this.len-=8,c.call(this,b)})},p=function(a){return this.metadata[a]=this.stream.readString(this.len,"utf8")},o("©alb","album",p),o("©arg","arranger",p),o("©art","artist",p),o("©ART","artist",p),o("aART","albumArtist",p),o("catg","category",p),o("©com","composer",p),o("©cpy","copyright",p),o("cprt","copyright",p),o("©cmt","comments",p),o("©day","releaseDate",p),o("desc","description",p),o("©gen","genre",p),o("©grp","grouping",p),o("©isr","ISRC",p),o("keyw","keywords",p),o("©lab","recordLabel",p),o("ldes","longDescription",p),o("©lyr","lyrics",p),o("©nam","title",p),o("©phg","recordingCopyright",p),o("©prd","producer",p),o("©prf","performers",p),o("purd","purchaseDate",p),o("purl","podcastURL",p),o("©swf","songwriter",p),o("©too","encoder",p),o("©wrt","composer",p),o("covr","coverArt",function(a){return this.metadata[a]=this.stream.readBuffer(this.len)}),n=["Blues","Classic Rock","Country","Dance","Disco","Funk","Grunge","Hip-Hop","Jazz","Metal","New Age","Oldies","Other","Pop","R&B","Rap","Reggae","Rock","Techno","Industrial","Alternative","Ska","Death Metal","Pranks","Soundtrack","Euro-Techno","Ambient","Trip-Hop","Vocal","Jazz+Funk","Fusion","Trance","Classical","Instrumental","Acid","House","Game","Sound Clip","Gospel","Noise","AlternRock","Bass","Soul","Punk","Space","Meditative","Instrumental Pop","Instrumental Rock","Ethnic","Gothic","Darkwave","Techno-Industrial","Electronic","Pop-Folk","Eurodance","Dream","Southern Rock","Comedy","Cult","Gangsta","Top 40","Christian Rap","Pop/Funk","Jungle","Native American","Cabaret","New Wave","Psychadelic","Rave","Showtunes","Trailer","Lo-Fi","Tribal","Acid Punk","Acid Jazz","Polka","Retro","Musical","Rock & Roll","Hard Rock","Folk","Folk/Rock","National Folk","Swing","Fast Fusion","Bebob","Latin","Revival","Celtic","Bluegrass","Avantgarde","Gothic Rock","Progressive Rock","Psychedelic Rock","Symphonic Rock","Slow Rock","Big Band","Chorus","Easy Listening","Acoustic","Humour","Speech","Chanson","Opera","Chamber Music","Sonata","Symphony","Booty Bass","Primus","Porn Groove","Satire","Slow Jam","Club","Tango","Samba","Folklore","Ballad","Power Ballad","Rhythmic Soul","Freestyle","Duet","Punk Rock","Drum Solo","A Capella","Euro-House","Dance Hall"],o("gnre","genre",function(a){return this.metadata[a]=n[this.stream.readUInt16()-1]}),o("tmpo","tempo",function(a){return this.metadata[a]=this.stream.readUInt16()}),o("rtng","rating",function(a){var b;return b=this.stream.readUInt8(),this.metadata[a]=2===b?"Clean":0!==b?"Explicit":"None"}),m=function(a){return this.stream.advance(2),this.metadata[a]=this.stream.readUInt16()+" of "+this.stream.readUInt16(),this.stream.advance(this.len-6)},o("disk","diskNumber",m),o("trkn","trackNumber",m),k=function(a){return this.metadata[a]=1===this.stream.readUInt8()},o("cpil","compilation",k),o("pcst","podcast",k),o("pgap","gapless",k),b}(c.Demuxer);var k,d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};k=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}return e(b,a),c.Demuxer.register(b),b.probe=function(a){var b;return"FORM"===a.peekString(0,4)&&("AIFF"===(b=a.peekString(8,4))||"AIFC"===b)},b.prototype.readChunk=function(){var a,b,c,d;if(!this.readStart&&this.stream.available(12)){if("FORM"!==this.stream.readString(4))return this.emit("error","Invalid AIFF.");if(this.fileSize=this.stream.readUInt32(),this.fileType=this.stream.readString(4),this.readStart=!0,"AIFF"!==(d=this.fileType)&&"AIFC"!==d)return this.emit("error","Invalid AIFF.")}for(;this.stream.available(1);){switch(!this.readHeaders&&this.stream.available(8)&&(this.type=this.stream.readString(4),this.len=this.stream.readUInt32()),this.type){case"COMM":if(!this.stream.available(this.len))return;this.format={formatID:"lpcm",channelsPerFrame:this.stream.readUInt16(),sampleCount:this.stream.readUInt32(),bitsPerChannel:this.stream.readUInt16(),sampleRate:this.stream.readFloat80(),framesPerPacket:1,littleEndian:!1,floatingPoint:!1},this.format.bytesPerPacket=this.format.bitsPerChannel/8*this.format.channelsPerFrame,"AIFC"===this.fileType&&(b=this.stream.readString(4),this.format.littleEndian="sowt"===b&&this.format.bitsPerChannel>8,this.format.floatingPoint="fl32"===b||"fl64"===b,("twos"===b||"sowt"===b||"fl32"===b||"fl64"===b||"NONE"===b)&&(b="lpcm"),this.format.formatID=b,this.len-=4),this.stream.advance(this.len-18),this.emit("format",this.format),this.emit("duration",this.format.sampleCount/this.format.sampleRate*1e3|0);break;case"SSND":this.readSSNDHeader&&this.stream.available(4)||(c=this.stream.readUInt32(),this.stream.advance(4),this.stream.advance(c),this.readSSNDHeader=!0),a=this.stream.readSingleBuffer(this.len),this.len-=a.length,this.readHeaders=this.len>0,this.emit("data",a);break;default:if(!this.stream.available(this.len))return;this.stream.advance(this.len)}"SSND"!==this.type&&(this.readHeaders=!1)}},b}(c.Demuxer);var l,d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};l=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}var d;return e(b,a),c.Demuxer.register(b),b.probe=function(a){return"RIFF"===a.peekString(0,4)&&"WAVE"===a.peekString(8,4)},d={1:"lpcm",3:"lpcm",6:"alaw",7:"ulaw"},b.prototype.readChunk=function(){var a,b,c;if(!this.readStart&&this.stream.available(12)){if("RIFF"!==this.stream.readString(4))return this.emit("error","Invalid WAV file.");if(this.fileSize=this.stream.readUInt32(!0),this.readStart=!0,"WAVE"!==this.stream.readString(4))return this.emit("error","Invalid WAV file.")}for(;this.stream.available(1);){switch(!this.readHeaders&&this.stream.available(8)&&(this.type=this.stream.readString(4),this.len=this.stream.readUInt32(!0)),this.type){case"fmt ":if(c=this.stream.readUInt16(!0),!(c in d))return this.emit("error","Unsupported format in WAV file.");this.format={formatID:d[c],floatingPoint:3===c,littleEndian:"lpcm"===d[c],channelsPerFrame:this.stream.readUInt16(!0),sampleRate:this.stream.readUInt32(!0),framesPerPacket:1},this.stream.advance(4),this.stream.advance(2),this.format.bitsPerChannel=this.stream.readUInt16(!0),this.format.bytesPerPacket=this.format.bitsPerChannel/8*this.format.channelsPerFrame,this.emit("format",this.format),this.stream.advance(this.len-16);break;case"data":this.sentDuration||(b=this.format.bitsPerChannel/8,this.emit("duration",this.len/b/this.format.channelsPerFrame/this.format.sampleRate*1e3|0),this.sentDuration=!0),a=this.stream.readSingleBuffer(this.len),this.len-=a.length,this.readHeaders=this.len>0,this.emit("data",a);break;default:if(!this.stream.available(this.len))return;this.stream.advance(this.len)}"data"!==this.type&&(this.readHeaders=!1)}},b}(c.Demuxer);var m,d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};m=function(a){function b(){return b.__super__.constructor.apply(this,arguments)}var d,f;return e(b,a),c.Demuxer.register(b),b.probe=function(a){return".snd"===a.peekString(0,4)},d=[8,8,16,24,32,32,64],d[26]=8,f={1:"ulaw",27:"alaw"},b.prototype.readChunk=function(){var a,b,c,e;if(!this.readHeader&&this.stream.available(24)){if(".snd"!==this.stream.readString(4))return this.emit("error","Invalid AU file.");if(e=this.stream.readUInt32(),b=this.stream.readUInt32(),c=this.stream.readUInt32(),this.format={formatID:f[c]||"lpcm",littleEndian:!1,floatingPoint:6===c||7===c,bitsPerChannel:d[c-1],sampleRate:this.stream.readUInt32(),channelsPerFrame:this.stream.readUInt32(),framesPerPacket:1},null==this.format.bitsPerChannel)return this.emit("error","Unsupported encoding in AU file.");this.format.bytesPerPacket=this.format.bitsPerChannel/8*this.format.channelsPerFrame,4294967295!==b&&(a=this.format.bitsPerChannel/8,this.emit("duration",b/a/this.format.channelsPerFrame/this.format.sampleRate*1e3|0)),this.emit("format",this.format),this.readHeader=!0}if(this.readHeader)for(;this.stream.available(1);)this.emit("data",this.stream.readSingleBuffer(this.stream.remainingBytes()))},b}(c.Demuxer);var n,h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};n=function(a){function b(){return this.readChunk=h(this.readChunk,this),b.__super__.constructor.apply(this,arguments)}return e(b,a),c.Decoder.register("lpcm",b),b.prototype.readChunk=function(){var a,b,c,d,e,f,g,h,i,j,k,l;if(f=this.stream,c=this.format.littleEndian,a=Math.min(4096,f.remainingBytes()),e=a/(this.format.bitsPerChannel/8)|0,a<this.format.bitsPerChannel/8)return null;if(this.format.floatingPoint)switch(this.format.bitsPerChannel){case 32:for(d=new Float32Array(e),b=g=0;e>g;b=g+=1)d[b]=f.readFloat32(c);break;case 64:for(d=new Float64Array(e),b=h=0;e>h;b=h+=1)d[b]=f.readFloat64(c);break;default:throw new Error("Unsupported bit depth.")}else switch(this.format.bitsPerChannel){case 8:for(d=new Int8Array(e),b=i=0;e>i;b=i+=1)d[b]=f.readInt8();break;case 16:for(d=new Int16Array(e),b=j=0;e>j;b=j+=1)d[b]=f.readInt16(c);break;case 24:for(d=new Int32Array(e),b=k=0;e>k;b=k+=1)d[b]=f.readInt24(c);break;case 32:for(d=new Int32Array(e),b=l=0;e>l;b=l+=1)d[b]=f.readInt32(c);break;default:throw new Error("Unsupported bit depth.")}return d},b}(c.Decoder);var o,h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};o=function(a){function b(){return this.readChunk=h(this.readChunk,this),b.__super__.constructor.apply(this,arguments)}var d,f,g,i,j;return e(b,a),c.Decoder.register("ulaw",b),c.Decoder.register("alaw",b),j=128,f=15,i=4,g=112,d=132,b.prototype.init=function(){var a,b,c,e,h,k,l;if(this.format.bitsPerChannel=16,this.table=e=new Int16Array(256),"ulaw"===this.format.formatID)for(a=k=0;256>k;a=++k)h=~a,c=((h&f)<<3)+d,c<<=(h&g)>>>i,e[a]=h&j?d-c:c-d;else for(a=l=0;256>l;a=++l)h=85^a,c=h&f,b=(h&g)>>>i,c=b?c+c+1+32<<b+2:c+c+1<<3,e[a]=h&j?c:-c},b.prototype.readChunk=function(){var a,b,c,d,e,f;if(d=this.stream,e=this.table,c=Math.min(4096,this.stream.remainingBytes()),0!==c){for(b=new Int16Array(c),a=f=0;c>f;a=f+=1)b[a]=e[d.readUInt8()];return b}},b}(c.Decoder);var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.HTTPSource=function(a){function b(a){this.url=a,this.chunkSize=1<<20,this.inflight=!1,this.reset()}return e(b,a),b.prototype.start=function(){return this.length&&!this.inflight?this.loop():(this.inflight=!0,this.xhr=new XMLHttpRequest,this.xhr.onload=function(a){return function(b){return a.length=parseInt(a.xhr.getResponseHeader("Content-Length")),a.inflight=!1,a.loop()}}(this),this.xhr.onerror=function(a){return function(b){return a.pause(),a.emit("error",b)}}(this),this.xhr.onabort=function(a){return function(b){return a.inflight=!1}}(this),this.xhr.open("HEAD",this.url,!0),this.xhr.send(null))},b.prototype.loop=function(){var a;return this.inflight||!this.length?this.emit("error","Something is wrong in HTTPSource.loop"):(this.inflight=!0,this.xhr=new XMLHttpRequest,this.xhr.onload=function(a){return function(b){var d,e,f,g,h,i;if(a.xhr.response)d=new Uint8Array(a.xhr.response);else for(g=a.xhr.responseText,d=new Uint8Array(g.length),f=h=0,i=g.length;i>=0?i>h:h>i;f=i>=0?++h:--h)d[f]=255&g.charCodeAt(f);return e=new c.Buffer(d),a.offset+=e.length,a.emit("data",e),a.offset>=a.length&&a.emit("end"),a.inflight=!1,a.offset>=a.length?void 0:a.loop()}}(this),this.xhr.onprogress=function(a){return function(b){return a.emit("progress",(a.offset+b.loaded)/a.length*100)}}(this),this.xhr.onerror=function(a){return function(b){return a.emit("error",b),a.pause()}}(this),this.xhr.onabort=function(a){return function(b){return a.inflight=!1}}(this),this.xhr.open("GET",this.url,!0),this.xhr.responseType="arraybuffer",a=Math.min(this.offset+this.chunkSize,this.length),this.xhr.setRequestHeader("Range","bytes="+this.offset+"-"+a),this.xhr.overrideMimeType("text/plain; charset=x-user-defined"),this.xhr.send(null))},b.prototype.pause=function(){var a;return this.inflight=!1,null!=(a=this.xhr)?a.abort():void 0},b.prototype.reset=function(){return this.pause(),this.offset=0},b}(c.EventEmitter);var d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};c.FileSource=function(a){function b(a){return this.file=a,"undefined"==typeof FileReader||null===FileReader?this.emit("error","This browser does not have FileReader support."):(this.offset=0,this.length=this.file.size,this.chunkSize=1<<20,void(this.file[this.slice="slice"]||this.file[this.slice="webkitSlice"]||this.file[this.slice="mozSlice"]))}return e(b,a),b.prototype.start=function(){return this.reader&&!this.active?this.loop():(this.reader=new FileReader,this.active=!0,this.reader.onload=function(a){return function(b){var d;return d=new c.Buffer(new Uint8Array(b.target.result)),a.offset+=d.length,a.emit("data",d),a.active=!1,a.offset<a.length?a.loop():void 0}}(this),this.reader.onloadend=function(a){return function(){return a.offset===a.length?(a.emit("end"),a.reader=null):void 0}}(this),this.reader.onerror=function(a){return function(b){return a.emit("error",b)}}(this),this.reader.onprogress=function(a){return function(b){return a.emit("progress",(a.offset+b.loaded)/a.length*100)}}(this),this.loop())},b.prototype.loop=function(){var a,b;return this.active=!0,b=Math.min(this.offset+this.chunkSize,this.length),a=this.file[this.slice](this.offset,b),this.reader.readAsArrayBuffer(a)},b.prototype.pause=function(){var a;this.active=!1;try{return null!=(a=this.reader)?a.abort():void 0}catch(b){}},b.prototype.reset=function(){return this.pause(),this.offset=0},b}(c.EventEmitter),a.prototype.initialize=function(){if(!(this.fromSampleRate>0&&this.toSampleRate>0&&this.channels>0))throw new Error("Invalid settings specified for the resampler.");this.fromSampleRate==this.toSampleRate?(this.resampler=this.bypassResampler,this.ratioWeight=1):(this.fromSampleRate<this.toSampleRate?(this.compileLinearInterpolationFunction(),this.lastWeight=1):(this.compileMultiTapFunction(),this.tailExists=!1,this.lastWeight=0),this.ratioWeight=this.fromSampleRate/this.toSampleRate,this.initializeBuffers())},a.prototype.compileLinearInterpolationFunction=function(){for(var a="var bufferLength = buffer.length;	var outLength = this.outputBufferSize;	if ((bufferLength % "+this.channels+") == 0) {		if (bufferLength > 0) {			var ratioWeight = this.ratioWeight;			var weight = this.lastWeight;			var firstWeight = 0;			var secondWeight = 0;			var sourceOffset = 0;			var outputOffset = 0;			var outputBuffer = this.outputBuffer;			for (; weight < 1; weight += ratioWeight) {				secondWeight = weight % 1;				firstWeight = 1 - secondWeight;",b=0;b<this.channels;++b)a+="outputBuffer[outputOffset++] = (this.lastOutput["+b+"] * firstWeight) + (buffer["+b+"] * secondWeight);";a+="}			weight -= 1;			for (bufferLength -= "+this.channels+", sourceOffset = Math.floor(weight) * "+this.channels+"; outputOffset < outLength && sourceOffset < bufferLength;) {				secondWeight = weight % 1;				firstWeight = 1 - secondWeight;";for(var b=0;b<this.channels;++b)a+="outputBuffer[outputOffset++] = (buffer[sourceOffset"+(b>0?" + "+b:"")+"] * firstWeight) + (buffer[sourceOffset + "+(this.channels+b)+"] * secondWeight);";a+="weight += ratioWeight;				sourceOffset = Math.floor(weight) * "+this.channels+";			}";for(var b=0;b<this.channels;++b)a+="this.lastOutput["+b+"] = buffer[sourceOffset++];";a+='this.lastWeight = weight % 1;			return this.bufferSlice(outputOffset);		}		else {			return (this.noReturn) ? 0 : [];		}	}	else {		throw(new Error("Buffer was of incorrect sample length."));	}',this.resampler=Function("buffer",a)},a.prototype.compileMultiTapFunction=function(){for(var a="var bufferLength = buffer.length;	var outLength = this.outputBufferSize;	if ((bufferLength % "+this.channels+") == 0) {		if (bufferLength > 0) {			var ratioWeight = this.ratioWeight;			var weight = 0;",b=0;b<this.channels;++b)a+="var output"+b+" = 0;";for(a+="var actualPosition = 0;			var amountToNext = 0;			var alreadyProcessedTail = !this.tailExists;			this.tailExists = false;			var outputBuffer = this.outputBuffer;			var outputOffset = 0;			var currentPosition = 0;			do {				if (alreadyProcessedTail) {					weight = ratioWeight;",b=0;b<this.channels;++b)a+="output"+b+" = 0;";for(a+="}				else {					weight = this.lastWeight;",b=0;b<this.channels;++b)a+="output"+b+" = this.lastOutput["+b+"];";for(a+="alreadyProcessedTail = true;				}				while (weight > 0 && actualPosition < bufferLength) {					amountToNext = 1 + actualPosition - currentPosition;					if (weight >= amountToNext) {",b=0;b<this.channels;++b)a+="output"+b+" += buffer[actualPosition++] * amountToNext;";for(a+="currentPosition = actualPosition;						weight -= amountToNext;					}					else {",b=0;b<this.channels;++b)a+="output"+b+" += buffer[actualPosition"+(b>0?" + "+b:"")+"] * weight;";for(a+="currentPosition += weight;						weight = 0;						break;					}				}				if (weight == 0) {",b=0;b<this.channels;++b)a+="outputBuffer[outputOffset++] = output"+b+" / ratioWeight;";for(a+="}				else {					this.lastWeight = weight;",b=0;b<this.channels;++b)a+="this.lastOutput["+b+"] = output"+b+";";a+='this.tailExists = true;					break;				}			} while (actualPosition < bufferLength && outputOffset < outLength);			return this.bufferSlice(outputOffset);		}		else {			return (this.noReturn) ? 0 : [];		}	}	else {		throw(new Error("Buffer was of incorrect sample length."));	}',this.resampler=Function("buffer",a)},a.prototype.bypassResampler=function(a){return this.noReturn?(this.outputBuffer=a,a.length):a},a.prototype.bufferSlice=function(a){if(this.noReturn)return a;try{return this.outputBuffer.subarray(0,a)}catch(b){try{return this.outputBuffer.length=a,
this.outputBuffer}catch(b){return this.outputBuffer.slice(0,a)}}},a.prototype.initializeBuffers=function(){try{this.outputBuffer=new Float32Array(this.outputBufferSize),this.lastOutput=new Float32Array(this.channels)}catch(a){this.outputBuffer=[],this.lastOutput=[]}};var p,h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};p=function(d){function f(b,c){this.sampleRate=b,this.channels=c,this.refill=h(this.refill,this),this.context=null!=j?j:j=new g,this.deviceSampleRate=this.context.sampleRate,this.bufferSize=Math.ceil(4096/(this.deviceSampleRate/this.sampleRate)*this.channels),this.bufferSize+=this.bufferSize%this.channels,this.deviceSampleRate!==this.sampleRate&&(this.resampler=new a(this.sampleRate,this.deviceSampleRate,this.channels,4096*this.channels)),this.node=this.context[i](4096,this.channels,this.channels),this.node.onaudioprocess=this.refill,this.node.connect(this.context.destination)}var g,i,j;return e(f,d),c.AudioDevice.register(f),g=b.AudioContext||b.webkitAudioContext,f.supported=g&&("function"==typeof g.prototype[i="createScriptProcessor"]||"function"==typeof g.prototype[i="createJavaScriptNode"]),j=null,f.prototype.refill=function(a){var b,c,d,e,f,g,h,i,j,k;for(g=a.outputBuffer,b=g.numberOfChannels,c=new Array(b),e=h=0;b>h;e=h+=1)c[e]=g.getChannelData(e);for(d=new Float32Array(this.bufferSize),this.emit("refill",d),this.resampler&&(d=this.resampler.resampler(d)),e=i=0,k=g.length;k>i;e=i+=1)for(f=j=0;b>j;f=j+=1)c[f][e]=d[e*b+f]},f.prototype.destroy=function(){return this.node.disconnect(0)},f.prototype.getDeviceTime=function(){return this.context.currentTime*this.sampleRate},f}(c.EventEmitter);var q,h=function(a,b){return function(){return a.apply(b,arguments)}},d={}.hasOwnProperty,e=function(a,b){function c(){this.constructor=a}for(var e in b)d.call(b,e)&&(a[e]=b[e]);return c.prototype=b.prototype,a.prototype=new c,a.__super__=b.prototype,a};return q=function(a){function b(a,b){this.sampleRate=a,this.channels=b,this.refill=h(this.refill,this),this.audio=new Audio,this.audio.mozSetup(this.channels,this.sampleRate),this.writePosition=0,this.prebufferSize=this.sampleRate/2,this.tail=null,this.timer=d(this.refill,100)}var d,f;return e(b,a),c.AudioDevice.register(b),b.supported="undefined"!=typeof Audio&&null!==Audio&&"mozWriteAudio"in new Audio,b.prototype.refill=function(){var a,b,c,d;this.tail&&(d=this.audio.mozWriteAudio(this.tail),this.writePosition+=d,this.tail=this.writePosition<this.tail.length?this.tail.subarray(d):null),c=this.audio.mozCurrentSampleOffset(),a=c+this.prebufferSize-this.writePosition,a>0&&(b=new Float32Array(a),this.emit("refill",b),d=this.audio.mozWriteAudio(b),d<b.length&&(this.tail=b.subarray(d)),this.writePosition+=d)},b.prototype.destroy=function(){return f(this.timer)},b.prototype.getDeviceTime=function(){return this.audio.mozCurrentSampleOffset()/this.channels},d=function(a,b){var d,e;return d=c.Buffer.makeBlobURL("setInterval(function() { postMessage('ping'); }, "+b+");"),null==d?setInterval(a,b):(e=new Worker(d),e.onmessage=a,e.url=d,e)},f=function(a){return a.terminate?(a.terminate(),URL.revokeObjectURL(a.url)):clearInterval(a)},b}(c.EventEmitter),b.AV=c}(),function(){var a=AV.Demuxer.extend(function(){AV.Demuxer.register(this),this.probe=function(a){return"fLaC"===a.peekString(0,4)};const a=0,b=1,c=2,d=3,e=4,f=5,g=6,h=127,i=34;this.prototype.readChunk=function(){var b=this.stream;if(!this.readHeader&&b.available(4)){if("fLaC"!==b.readString(4))return this.emit("error","Invalid FLAC file.");this.readHeader=!0}for(;b.available(1)&&!this.last;){if(!this.readBlockHeaders){var c=b.readUInt8();this.last=128===(128&c),this.type=127&c,this.size=b.readUInt24()}if(!this.foundStreamInfo&&this.type!==a)return this.emit("error","STREAMINFO must be the first block");if(!b.available(this.size))return;switch(this.type){case a:if(this.foundStreamInfo)return this.emit("error","STREAMINFO can only occur once.");if(this.size!==i)return this.emit("error","STREAMINFO size is wrong.");this.foundStreamInfo=!0;var f=new AV.Bitstream(b),h={minBlockSize:f.read(16),maxBlockSize:f.read(16),minFrameSize:f.read(24),maxFrameSize:f.read(24)};this.format={formatID:"flac",sampleRate:f.read(20),channelsPerFrame:f.read(3)+1,bitsPerChannel:f.read(5)+1},this.emit("format",this.format),this.emit("cookie",h);var j=f.read(36);this.emit("duration",j/this.format.sampleRate*1e3|0),b.advance(16),this.readBlockHeaders=!1;break;case d:for(var k=0;k<this.size/18;k++)if(4294967295==b.peekUInt32(0)&&4294967295==b.peekUInt32(1))b.advance(18);else{b.readUInt32()>0&&this.emit("error","Seek points with sample number >UInt32 not supported");var l=b.readUInt32();b.readUInt32()>0&&this.emit("error","Seek points with stream offset >UInt32 not supported");var m=b.readUInt32();b.advance(2),this.addSeekPoint(m,l)}break;case e:this.metadata||(this.metadata={});var n=b.readUInt32(!0);this.metadata.vendor=b.readString(n);for(var o=b.readUInt32(!0),p=0;o>p;p++){n=b.readUInt32(!0);var q=b.readString(n,"utf8"),r=q.indexOf("=");this.metadata[q.slice(0,r).toLowerCase()]=q.slice(r+1)}break;case g:var s=b.readUInt32();if(3!==s)b.advance(this.size-4);else{var t=b.readUInt32(),u=b.readString(t),v=b.readUInt32(),w=b.readString(v),x=b.readUInt32(),y=b.readUInt32(),z=b.readUInt32(),A=b.readUInt32(),o=b.readUInt32(),B=b.readBuffer(o);this.metadata||(this.metadata={}),this.metadata.coverArt=B}break;default:b.advance(this.size),this.readBlockHeaders=!1}this.last&&this.metadata&&this.emit("metadata",this.metadata)}for(;b.available(1)&&this.last;){var C=b.readSingleBuffer(b.remainingBytes());this.emit("data",C)}}}),b=AV.Decoder.extend(function(){function a(a){for(var b=0,c=0;;){if(c=a>>>24)break;if(b+=8,c=a>>>16,255&c)break;if(b+=8,c=a>>>8,255&c)break;if(b+=8,c=a,255&c)break;return b+=8}return 240&c?c>>>=4:b+=4,8&c?b:4&c?b+1:2&c?b+2:1&c?b+3:b+4}AV.Decoder.register("flac",this),this.prototype.setCookie=function(a){this.cookie=a,this.decoded=[];for(var b=0;b<this.format.channelsPerFrame;b++)this.decoded[b]=new Int32Array(a.maxBlockSize)};const b=new Int16Array([0,192,576,1152,2304,4608,0,0,256,512,1024,2048,4096,8192,16384,32768]),c=new Int32Array([0,88200,176400,192e3,8e3,16e3,22050,24e3,32e3,44100,48e3,96e3,0,0,0,0]),d=new Int8Array([0,8,12,0,16,20,24,0]),e=8,f=0,g=8,h=9,i=10;this.prototype.readChunk=function(){var a=this.bitstream;if(a.available(32)){if(32764!==(32767&a.read(15)))throw new Error("Invalid sync code");var j=a.read(1),k=a.read(4),l=a.read(4),m=a.read(4),n=a.read(3);a.advance(1),this.chMode=m;var o;if(e>m)o=m+1,this.chMode=f;else{if(!(i>=m))throw new Error("Invalid channel mode");o=2}if(o!==this.format.channelsPerFrame)throw new Error("Switching channel layout mid-stream not supported.");if(3===n||7===n)throw new Error("Invalid sample size code");if(this.bps=d[n],this.bps!==this.format.bitsPerChannel)throw new Error("Switching bits per sample mid-stream not supported.");var p,q;this.bps>16?(p=32-this.bps,q=!0):(p=16-this.bps,q=!1);for(var r=0;1===a.read(1);)r++;for(var s=a.read(7-r);r>1;r--)a.advance(2),s=s<<6|a.read(6);if(0===k)throw new Error("Reserved blocksize code");this.blockSize=6===k?a.read(8)+1:7===k?a.read(16)+1:b[k];var t;if(12>l)t=c[l];else if(12===l)t=1e3*a.read(8);else if(13===l)t=a.read(16);else{if(14!==l)throw new Error("Invalid sample rate code");t=10*a.read(16)}a.advance(8);for(var u=0;o>u;u++)this.decodeSubframe(u);a.align(),a.advance(16);var v=new ArrayBuffer(this.blockSize*o*this.bps/8),w=q?new Int32Array(v):new Int16Array(v),x=this.blockSize,y=this.decoded,z=0;switch(this.chMode){case f:for(var A=0;x>A;A++)for(var u=0;o>u;u++)w[z++]=y[u][A]<<p;break;case g:for(var u=0;x>u;u++){var B=y[0][u],C=y[1][u];w[z++]=B<<p,w[z++]=B-C<<p}break;case h:for(var u=0;x>u;u++){var B=y[0][u],C=y[1][u];w[z++]=B+C<<p,w[z++]=C<<p}break;case i:for(var u=0;x>u;u++){var B=y[0][u],C=y[1][u];B-=C>>1,w[z++]=B+C<<p,w[z++]=B<<p}}return w}},this.prototype.decodeSubframe=function(a){var b=0,c=this.bitstream,d=this.blockSize,e=this.decoded;if(this.curr_bps=this.bps,0===a?this.chMode===h&&this.curr_bps++:(this.chMode===g||this.chMode===i)&&this.curr_bps++,c.read(1))throw new Error("Invalid subframe padding");var f=c.read(6);if(c.read(1)){for(b=1;!c.read(1);)b++;this.curr_bps-=b}if(this.curr_bps>32)throw new Error("decorrelated bit depth > 32 ("+this.curr_bps+")");if(0===f)for(var j=c.read(this.curr_bps,!0),k=0;d>k;k++)e[a][k]=j;else if(1===f)for(var l=this.curr_bps,k=0;d>k;k++)e[a][k]=c.read(l,!0);else if(f>=8&&12>=f)this.decode_subframe_fixed(a,-9&f);else{if(!(f>=32))throw new Error("Invalid coding type");this.decode_subframe_lpc(a,(-33&f)+1)}if(b)for(var k=0;d>k;k++)e[a][k]<<=b},this.prototype.decode_subframe_fixed=function(a,b){for(var c=this.decoded[a],d=this.bitstream,e=this.curr_bps,f=0;b>f;f++)c[f]=d.read(e,!0);this.decode_residuals(a,b);var g=0,h=0,i=0,j=0;switch(b>0&&(g=c[b-1]),b>1&&(h=g-c[b-2]),b>2&&(i=h-c[b-2]+c[b-3]),b>3&&(j=i-c[b-2]+2*c[b-3]-c[b-4]),b){case 0:break;case 1:case 2:case 3:case 4:for(var k=new Int32Array([g,h,i,j]),l=this.blockSize,f=b;l>f;f++){k[b-1]+=c[f];for(var m=b-2;m>=0;m--)k[m]+=k[m+1];c[f]=k[0]}break;default:throw new Error("Invalid Predictor Order "+b)}},this.prototype.decode_subframe_lpc=function(a,b){for(var c=this.bitstream,d=this.decoded[a],e=this.curr_bps,f=this.blockSize,g=0;b>g;g++)d[g]=c.read(e,!0);var h=c.read(4)+1;if(16===h)throw new Error("Invalid coefficient precision");var i=c.read(5,!0);if(0>i)throw new Error("Negative qlevel, maybe buggy stream");for(var j=new Int32Array(32),g=0;b>g;g++)j[g]=c.read(h,!0);if(this.decode_residuals(a,b),this.bps>16)throw new Error("no 64-bit integers in JS, could probably use doubles though");for(var g=b;f-1>g;g+=2){for(var k=d[g-b],l=0,m=0,n,o=b-1;o>0;o--)n=j[o],l+=n*k,k=d[g-o],m+=n*k;n=j[0],l+=n*k,k=d[g]+=l>>i,m+=n*k,d[g+1]+=m>>i}if(f>g){for(var p=0,o=0;b>o;o++)p+=j[o]*d[g-o-1];d[g]+=p>>i}};const j=32767;this.prototype.decode_residuals=function(a,b){var c=this.bitstream,d=c.read(2);if(d>1)throw new Error("Illegal residual coding method "+d);var e=c.read(4),f=this.blockSize>>>e;if(b>f)throw new Error("Invalid predictor order "+b+" > "+f);for(var g=this.decoded[a],h=b,i=b,k=0;1<<e>k;k++){var l=c.read(0===d?4:5);if(l===(0===d?15:31))for(l=c.read(5);f>i;i++)g[h++]=c.read(l,!0);else for(;f>i;i++)g[h++]=this.golomb(l,j,0);i=0}};const k=25;this.prototype.golomb=function(b,c,d){var e=this.bitstream,f=e.bitPosition,g=e.peek(32-f)<<f,h=0,i=31-a(1|g);if(i-b>=7&&c>32-i)g>>>=i-b,g+=30-i<<b,e.advance(32+b-i),h=g;else{for(var j=0;0===e.read(1);j++)g=e.peek(32-f)<<f;c-1>j?(g=b?e.read(b):0,h=g+(j<<b)):j===c-1?(g=e.read(d),h=g+1):h=-1}return h>>1^-(1&h)}})}();